package elaborator.utils;

import java.util.Map;

import elaborator.tests.TestDataGenerator;

/**
 * Singleton che si occupa di astrarre sui dati di test dai sensori,
 * dove c'è una doppia precauzione: Il TestDataGenerator cambierà 
 * in futuro quindi basta modificare questo per adattarlo al Receiver,
 * ma abbiamo anche un Adapter per cui questo Singleton potrà essere
 * eliminato a favore del solo Adapter.
 * @author koelio
 * @see AdapterSensorsReceiver
 * @see TestDataGenerator
 *
 */
public abstract class DataGenerator {

	public static DataGenerator dataGen;
	
	public abstract String getPlanet();
	
	public abstract int[] getTemps();
	
	public abstract int getDiameter();
	
	public abstract Map<Double, String> getComposition();
	
	public static DataGenerator getDataGenerator(){
		return dataGen;
	}
	public static void setDataGenerator(DataGenerator dataGen){
		DataGenerator.dataGen = dataGen;
	}
	
}
